' Collision Mask test example V1.0
' By David Powell
' http://www.loadcode.co.uk
' Released into the public domain

' Candy images from http://opengameart.org/content/candy-pack-1

#FAST_SYNC_PROJECT_DATA=True

Strict

Import mojo
Import collisionmask

Function Main:Int()
	New TestApp()
	Return 0
End

Class TestApp Extends App Implements IOnLoadMaskComplete
	'True if the two images have hit each other
	Field hit:Bool

	'The candy cane positioning and size
	Const CandyX:Int = 640 / 2
	Const CandyY:Int = 480 / 2
	Const CandyXScale:Float = 3
	Const CandyYScale:Float = 3
	Field candyRotateAngle:Float = 0.0

	'The candy can image and masks
	Field candyImage:Image
	Field candyMask:MasterMask
	Field scaledCandyMask:Mask

	'The bean positioning and size
	Const MaxBeanXScale:Float = 5
	Const MaxBeanYScale:Float = 5
	Field beanXScale:Float = 3
	Field beanYScale:Float = 3
	Field beanRotateAngle:Float = 0.0

	'The bean image and masks
	Field beanImage:Image
	Field beanMask:MasterMask
	Field scaledBeanMask:Mask

	'The rectangle position and size
	Const RectX:Int = 500
	Const RectY:Int = 100
	Const RectWidth:Int = 50
	Const RectHeight:Int = 50

	'The point position
	Const PointX:Int = 400
	Const PointY:Int = 400

	'The circle position
	Const CircleX:Int = 100
	Const CircleY:Int = 400
	Const CircleRadius:Int = 50

	'Toggle switches
	Field debugDisplay:Bool = False
	Field imageDisplay:Bool = True
	Field beanRotation:Bool = True

	Method OnCreate:Int()
		'Start to load the candy cane mask asynchronously
		LoadMaskAsync("monkey://data/candycane.cmsk", Mask.DefaultFlags, Self)
		
		'Load the candy cane image
		candyImage = LoadImage("monkey://data/candycane.png")
		If candyImage = Null Then Error("Can not load candy cane image")

		'Load the bean mask synchronously
		beanMask = LoadMask("monkey://data/bean_orange.cmsk", Mask.MidHandle)
		If beanMask = Null Then Error("Can not load bean mask")

		'Pre-allocate a large enough mask to take a rotated bean at the maximum allowed size
		scaledBeanMask = beanMask.PreAllocateMask(MaxBeanXScale, MaxBeanYScale)

		'Load the bean image
		beanImage = LoadImage("monkey://data/bean_orange.png", 1, Image.MidHandle)
		If beanImage = Null Then Error("Can not load bean image")
		
		beanMask.Threshold = 1
		
		SetUpdateRate(60)		
		Return 0
	End
	
	'Summary: Fired when a mask load has completed
	Method OnLoadMaskComplete:Void(mask:MasterMask, path:String)
		Select path
			Case "monkey://data/candycane.cmsk"
				If mask = Null Then Error "Can not load candy mask"
				candyMask = mask
				'Pre-allocate a large enough mask to take a rotated candy cane at the defined scale
				scaledCandyMask = candyMask.PreAllocateMask(CandyXScale, CandyYScale)
		End
	End
	
	Method OnUpdate:Int()
		'Don't do anything until the candy cane mask has finished loading
		If scaledCandyMask = Null
			UpdateAsyncEvents()
			Return 0
		EndIf
	
		'Check for user input and change switches accordingly
		If KeyHit(KEY_D) > 0 Then debugDisplay = Not debugDisplay
		If KeyHit(KEY_I) > 0 Then imageDisplay = Not imageDisplay
		If KeyHit(KEY_R) > 0 Then beanRotation = Not beanRotation
		
		If KeyDown(KEY_UP) > 0 And beanYScale > 0.5 Then beanYScale -= 0.1
		If KeyDown(KEY_DOWN) > 0 And beanYScale < MaxBeanYScale - 0.1 Then beanYScale += 0.1
		If KeyDown(KEY_LEFT) > 0 And beanXScale > 0.5 Then beanXScale -= 0.1
		If KeyDown(KEY_RIGHT) > 0 And beanXScale < MaxBeanXScale - 0.1 Then beanXScale += 0.1
		
		'Rotate both the candy cane and the bean
		candyRotateAngle += 0.7
		beanRotateAngle += 0.9
		
		'Scale and rotate the candy cane master mask and output the result into the scaled candy cane mask
		candyMask.ScaleAndRotate(CandyXScale, CandyYScale, candyRotateAngle, scaledCandyMask)
		
		If beanRotation = True
			'Scale and rotate the bean master mask and output the result into the scaled bean mask
			beanMask.ScaleAndRotate(beanXScale, beanYScale, beanRotateAngle, scaledBeanMask)
		Else
			'Scale the bean master mask and output the result into the scaled bean mask
			beanMask.Scale(beanXScale, beanYScale, scaledBeanMask)
		EndIf
		
		hit = False
		
		'Check to see if the two masks have collided; if so set the hit flag
		If scaledCandyMask.CollideMask(CandyX, CandyY, scaledBeanMask, MouseX(), MouseY()) = True
			hit = True
		EndIf
		
		If scaledBeanMask.CollideRect(MouseX(), MouseY(), RectX, RectY, RectWidth, RectHeight) = True
			hit = True
		EndIf
		
		If scaledBeanMask.CollidePoint(MouseX(), MouseY(), PointX, PointY) = True
			hit = True
		EndIf
		
		If scaledBeanMask.CollideCircle(MouseX(), MouseY(), CircleX, CircleY, CircleRadius) = True
			hit = True
		EndIf
		
		Return 0
	End
	
	Method OnRender:Int()
		'If the candy cane mask is still loading, just display loading screen
		If scaledCandyMask = Null
			Cls(0, 0, 0)
			DrawText("Loading...", 0, 0)
			Return 0
		EndIf
	
		'If scaledBeanMask.CollideCircle(MouseX(), MouseY(), CircleX, CircleY, CircleRadius) = True
		'	hit = True
		'EndIf
		
		'If the two masks have collided; change the background colour
		If hit = True
			Cls(255, 0, 0)
		Else
			Cls(0, 0, 255)
		EndIf
		
		'Display the controls in the top-left corner of the screen
		DrawText("Controls: ", 0, 0)
		DrawText("D - Toggle Debug Display", 0, 13)
		DrawText("I - Toggle Image Display", 0, 26)
		DrawText("R - Toggle Bean Rotation", 0, 39)
		DrawText("Arrow Keys - Change Bean Scaling", 0, 52)
		
		DrawRect(RectX, RectY, RectWidth, RectHeight)
		DrawPoint(PointX, PointY)
		DrawCircle(CircleX, CircleY, CircleRadius)
		
		'If scaledBeanMask.CollideCircle(MouseX(), MouseY(), CircleX, CircleY, CircleRadius) = True
		'	hit = True
		'EndIf
		
		'If required; display the candy cane image
		If imageDisplay = True
			DrawImage(candyImage, CandyX, CandyY, candyRotateAngle, CandyXScale, CandyYScale)
		EndIf
		
		'If the debug display switch is enabled; overlay the debug information for the candy cane
		If debugDisplay = True
			scaledCandyMask.DebugDraw(CandyX, CandyY, 0.5)
		EndIf
		
		'If required; display the bean image
		If imageDisplay = True
			If beanRotation = True
				DrawImage(beanImage, MouseX(), MouseY(), beanRotateAngle, beanXScale, beanYScale)
			Else
				DrawImage(beanImage, MouseX(), MouseY(), 0, beanXScale, beanYScale)
			EndIf
		EndIf
		
		'If the debug display switch is enabled; overlay the debug information for the bean
		If debugDisplay = True
			scaledBeanMask.DebugDraw(MouseX(), MouseY(), 0.5)
		EndIf
		
		Return 0
	End
	
End
